import React from 'react';
import { MapContainer, TileLayer, Marker, Popup } from 'react-leaflet';
import L from 'leaflet';
import 'leaflet/dist/leaflet.css';

// Corrige los íconos por defecto de Leaflet en React
delete L.Icon.Default.prototype._getIconUrl;
L.Icon.Default.mergeOptions({
  iconRetinaUrl: require('leaflet/dist/images/marker-icon-2x.png'),
  iconUrl: require('leaflet/dist/images/marker-icon.png'),
  shadowUrl: require('leaflet/dist/images/marker-shadow.png'),
});

// Íconos personalizados
const iconComisaria = new L.Icon({
  iconUrl: 'https://cdn-icons-png.flaticon.com/512/684/684908.png',
  iconSize: [32, 32],
});

const iconPlanta = new L.Icon({
  iconUrl: 'https://cdn-icons-png.flaticon.com/512/2991/2991148.png',
  iconSize: [32, 32],
});

// Ejemplo de datos
const comisarias = [
  /* {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 6",
    lat: -34.62283,
    lng: -58.48286,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 7",
    lat: -34.65137,
    lng: -58.47973,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 8",
    lat: -34.66502,
    lng: -58.48989,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 9",
    lat: -34.63493,
    lng: -58.46019,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 10",
    lat: -34.64875,
    lng: -58.46125,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 11",
    lat: -34.65996,
    lng: -58.46117,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 12",
    lat: -34.66205,
    lng: -58.44099,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 13",
    lat: -34.67196,
    lng: -58.44801,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 14",
    lat: -34.67641,
    lng: -58.45931,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 15",
    lat: -34.67784,
    lng: -58.44059,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 16",
    lat: -34.68485,
    lng: -58.43039,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 17",
    lat: -34.65976,
    lng: -58.42843,
    origen: "Nueva",
    tipo: "Compactadora"
  },
  {
    empresa: "URBASUR S.A.",
    municipio: "Lomas de Zamora",
    nombre: "CAF 18",
    lat: -34.67324,
    lng: -58.41948,
    origen: "Nueva",
    tipo: "Compactadora"
  } */
 {empresa: 'METAL SOLVER S.R.L.',municipio: 'PILAR',nombre: 'Ruta 25 y el Tropero, Villa Astolfi',lat: -34.536709302793874,lng:  -58.86541733269393,origen: 'Según excel',tipo: 'Compactadora'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'GENERAL SAN MARTÍN',nombre: '4. Puente Copan y Buen Ayre Ceamse (compactan en Sarandí)',lat: -34.5616290138276,lng:  -58.58341832274711,origen: 'Según excel',tipo: 'Compactadora'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'JOSÉ C. PAZ',nombre: 'Savatori 2035',lat: -34.51855675344709,lng:  -58.79984081920212,origen: 'Según excel',tipo: 'Compactadora'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'ESCOBAR',nombre: 'comisaria escobar',lat: -34.340601097507815,lng:  -58.78735777318015,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'TIGRE',nombre: 'comisaria tigre',lat: -34.40468252603229,lng:  -58.69212122141047,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SAN FERNANDO',nombre: 'comisaria san fernando',lat: -34.43625864719787,lng:  -58.55527445219208,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'ZÁRATE',nombre: 'comisaria zarate',lat: -34.09467372636227,lng:  -59.02364706154977,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'EXALT. DE LA CRUZ',nombre: 'comisaria exaltación de la cruz',lat: -34.33910012345033,lng:  -59.11179583643393,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SAN MIGUEL',nombre: 'comisaria san miguel',lat: -34.560714116756536,lng:  -58.74724785929400,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'TRES DE FEBRERO',nombre: 'comisaria tres de febrero',lat: -34.56238110452197,lng:  -58.62262537142563,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'VICENTE LÓPEZ',nombre: 'comisaria vicente lopez',lat: -34.50822941089336,lng:  -58.49231835321495,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SAN ISIDRO',nombre: 'comisaria san isidro',lat: -34.468228906272365,lng:  -58.51575380133597,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'BARADERO',nombre: 'comisaria baradero',lat: -33.85218752154373,lng:  -59.54115092829225,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SAN PEDRO',nombre: 'comisaria san pedro',lat: -33.685753035349514,lng:  -59.67182243273238,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'RAMALLO',nombre: 'comisaria ramallo',lat: -33.4833810858029,lng:  -60.00660197757291,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SAN NICOLÁS',nombre: 'comisaria san nicolas',lat: -33.33786443512053,lng:  -60.22070232006314,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'PERGAMINO',nombre: 'comisaria pergamino',lat: -33.889186702740396,lng:  -60.56957250503371,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'COLÓN',nombre: 'comisaria colon',lat: -33.897254666356226,lng:  -61.09748861923043,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'ROJAS',nombre: 'comisaria rojas',lat: -34.20043180528179,lng:  -60.73576011921667,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SALTO',nombre: 'comisaria salto',lat: -34.29253051525573,lng:  -60.25510844804843,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'CARMEN DE ARECO',nombre: 'comisaria carmen de areco',lat: -34.3759700172208,lng:  -59.82406800386539,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SAN ANDRÉS DE GILES',nombre: 'comisaria san andres de giles',lat: -34.445040548021176,lng:  -59.44675879444941,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SAN ANTONIO DE ARECO',nombre: 'comisaria san antonio de areco',lat: -34.243359730418284,lng:  -59.47439810202054,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'CAPITÁN SARMIENTO',nombre: 'comisaria capitan sarmineto',lat: -34.171412575320694,lng:  -59.79461526181423,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'ARRECIFES',nombre: 'comisaria arrecifes',lat: -34.06800911081046,lng:  -60.10877655278261,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'ITUZAINGÓ',nombre: 'Comisaria ituzaingo',lat: -34.61691646897603,lng:  -58.67567062600529,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'MERLO',nombre: 'Comisaria merlo',lat: -34.66518472901198,lng:  -58.69646430223346,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'MORENO',nombre: 'Comisaria moreno',lat: -34.64600717960945,lng:  -58.78770232351703,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'MARCOS PAZ',nombre: 'Comisaria marcos paz',lat: -34.780160971119315,lng:  -58.83895595041292,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'GENERAL LAS HERAS',nombre: 'Comisaria general las heras',lat: -34.928724333818984,lng:  -58.94777278849662,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'GENERAL RODRÍGUEZ',nombre: 'Comisaria general rodriguez',lat: -34.605299837660645,lng:  -58.95445444908955,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'LUJÁN',nombre: 'Comisaria luján',lat: -34.566667562699884,lng:  -59.11811541043404,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'LAS FLORES',nombre: 'Comisaria las flores',lat: -35.99284773260168,lng:  -59.10148751279549,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'TAPALQUÉ',nombre: 'Comisaria tapalqué',lat: -36.35359043943605,lng:  -60.02475458842951,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'AZUL',nombre: 'Comisaria azul',lat: -36.78189341016802,lng:  -59.82906091404136,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'BENITO JUÁREZ',nombre: 'Comisaria benito juarez',lat: -37.648796168491565,lng:  -59.85803246573477,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'LAPRIDA',nombre: 'Comisaria laprida',lat: -37.546312313482254,lng:  -60.79689296561118,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'GENERAL LA MADRID',nombre: 'Comisaria general la madrid',lat: -37.24931904774321,lng:  -61.26134158838627,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'OLAVARRÍA',nombre: 'Comisaria olavarría',lat: -36.89040044859675,lng:  -60.32437660212216,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'BOLIVAR',nombre: 'Comisaria bolivar',lat: -36.2307827858241,lng:  -61.11246200377885,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'DAIREAUX',nombre: 'Comisaria daireaux',lat: -36.59855004957127,lng:  -61.74487993444803,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'GUAMINÍ',nombre: 'Comisaria guamini',lat: -37.009743093069574,lng:  -62.42214780374121,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'ADOLFO ALSINA',nombre: 'Comisaria adolfo alsina',lat: -37.18025331085815,lng:  -62.76114555955385,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SALLIQUELÓ',nombre: 'Comisaria salliqueo',lat: -36.75130904497442,lng:  -62.96078710375376,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'TRES LOMAS',nombre: 'Comisaria tres lomas',lat: -36.459285908773666,lng:  -62.8618801172603,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'PELLEGRINI',nombre: 'Comisaria pellegrini',lat: -36.267683916369975,lng:  -63.16645905959785,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'TRENQUE LAUQUEN',nombre: 'Comisaria trenque lauquen',lat: -35.973850661990724,lng:  -62.73417605507775,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'RIVADAVIA',nombre: 'Comisaria rivadavia',lat: -34.84406402146396,lng:  -58.34896917368205,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'CARLOS TEJEDOR',nombre: 'Comisaria carlos tejedor',lat: -35.391728854984265,lng:  -62.41895230381839,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'PEHUAJÓ',nombre: 'Comisaria pehuajo',lat: -35.80882545047361,lng:  -61.89784695568532,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'HIPÓLITO YRIGOYEN',nombre: 'Comisaria hipólito yrigoyen',lat: -36.30463438421233,lng:  -61.74307576412411,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'CARLOS CASARES',nombre: 'Comisaria carlos casares',lat: -35.62239007029504,lng:  -61.36638795962831,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'NUEVE DE JULIO',nombre: 'Comisaria nueve de julio',lat: -35.44423795559895,lng:  -60.88729358488481,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'LINCOLN',nombre: 'Comisaria lincoln',lat: -34.86968111146959,lng:  -61.52178594091103,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'FLORENTINO AMEGHINO',nombre: 'Comisaria florentino ameghino',lat: -34.844436868586484,lng:  -62.46758381918723,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'GENERAL PINTO',nombre: 'Comisaria general pinto',lat: -34.765578240947455,lng:  -61.89133313083234,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'GENERAL VILLEGAS',nombre: 'Comisaria general villegas',lat: -35.03332945581625,lng:  -63.01541385807282,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'LEANDRO N. ALEM',nombre: 'Comisaria leandro n alem',lat: -34.52007066243871,lng:  -61.39207202897493,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'GENERAL ARENALES',nombre: 'Comisaria general arenales',lat: -34.304690634498094,lng:  -61.30588343270432,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'JUNÍN',nombre: 'Comisaria junín',lat: -34.59076868885107,lng:  -60.94357169623686,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'DEPOSITO JUNCAL',municipio: 'LA COSTA',nombre: '???',lat: -36.68983909472069,lng:  -56.70294236409953,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'DEPOSITO JUNCAL',municipio: 'PINAMAR',nombre: 'Comisaria Pinamar',lat: -37.094735155153636,lng:  -56.87968875270641,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'DEPOSITO JUNCAL',municipio: 'VILLA GESELL',nombre: 'Comisaria villa gesell',lat: -37.25405398414173,lng:  -56.97063357077692,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'AVELLANEDA',nombre: '1. ECO Punto Calle Nicaragua',lat: -34.66324221134056,lng:  -58.32457820301489,origen: 'Según excel',tipo: 'Compactadora'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'QUILMES',nombre: 'metal solver solano',lat: -34.78450158691393,lng:  -58.30115257501072,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'ESTEBAN ECHEVERRÍA',nombre: 'ecopunto esteban echeverria',lat: -34.85867285487254,lng:  -58.45843934111039,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'CORONEL ROSALES',nombre: 'Municipio coronel rosales',lat: -38.87954913909765,lng:  -62.07474483248436,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'MONTE HERMOSO',nombre: 'comisaria monte hermosos',lat: -38.98121599725812,lng:  -61.29133098208551,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'CORONEL DORREGO',nombre: 'comisaria coronel dorrego',lat: -38.71835646221026,lng:  -61.28688020365661,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'TRES ARROYOS',nombre: 'comisaria tres arroyos',lat: -38.37690594344966,lng:  -60.2776939862116,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'ADOLFO GONZALES CHAVES',nombre: 'comisaria gonzalez chaves',lat: -38.016460038494316,lng:  -60.10871708430951,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'CORONEL PRINGLES',nombre: 'comisaria coronel pringles',lat: -38.02458329615755,lng:  -61.38516824694774,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'CORONEL SUAREZ',nombre: 'comisaria coronel suarez',lat: -37.456419971459844,lng:  -61.9390802190629,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'SAAVEDRA',nombre: 'comisaria saavedra',lat: -34.55036009160923,lng:  -58.49930223432238,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'PUÁN',nombre: 'puán',lat: -37.541549094282324,lng:  -62.76043010120669,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'TORNQUIST',nombre: 'comisaria tornquist',lat: -38.131393968989755,lng:  -61.80320431902954,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'BAHÍA BLANCA',nombre: 'comisaria bahía blanca',lat: -38.67407647720118,lng:  -62.27560360726323,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'VILLARINO',nombre: 'comisaria villarino',lat: -39.223180049564455,lng:  -62.60908237704849,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'PATAGONES',nombre: 'comisaria patagones',lat: -40.796010095724235,lng:  -62.97862976243768,origen: 'Agregada manualmente',tipo: 'Comisaría'},
{empresa: 'METAL SOLVER S.R.L.',municipio: 'FLORENCIO VARELA',nombre: 'ecopunto florencio varela',lat: -34.78181309173852,lng:  -58.25268886924277,origen: 'Agregada manualmente',tipo: 'Comisaría'},
]

const plantas = [
  { id: 1, nombre: 'Planta A', lat: -36.6769, lng: -60.5801 },
  { id: 2, nombre: 'Planta B', lat: -35.1856, lng: -59.0952 },
];

const MapaBuenosAires = () => {
  return (
    <MapContainer center={[-36.5, -60]} zoom={6} style={{ height: '100vh', width: '100%' }}>
      <TileLayer
        attribution='&copy; OpenStreetMap'
        url="https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png"
      />

      {comisarias.map((com) => (
        <Marker key={com.id} position={[com.lat, com.lng]} icon={iconComisaria}>
          <Popup>
        <div style={{ minWidth: 200 }}>
          <h3 style={{ margin: '0 0 5px' }}>{com.nombre}</h3>
          <p style={{ margin: '2px 0' }}><strong>Empresa:</strong> {com.empresa}</p>
          <p style={{ margin: '2px 0' }}><strong>Municipio:</strong> {com.municipio}</p>
          <p style={{ margin: '2px 0' }}><strong>Tipo:</strong> {com.tipo}</p>
          <p style={{ margin: '2px 0', fontStyle: 'italic', color: '#555' }}>Origen: {com.origen}</p>
        </div>
      </Popup>
        </Marker>
      ))}

      {plantas.map((planta) => (
        <Marker key={planta.id} position={[planta.lat, planta.lng]} icon={iconPlanta}>
          <Popup>{planta.nombre}</Popup>
        </Marker>
      ))}
    </MapContainer>
  );
};

export default MapaBuenosAires;
